﻿* Encoding: UTF-8.


USE ALL.
EXECUTE.


CROSSTABS
  /TABLES=Rating BY Screens
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT
  /COUNT ROUND CELL.

RECODE Rating (1=1) (2=2) (3=3) (4=4) (5=5) (6=6) (7=6) (99=99) INTO Rating_d.
EXECUTE.



USE ALL.
COMPUTE filter_$=(Rating_d<7).
VARIABLE LABELS filter_$ 'Rating_d<7 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.



CROSSTABS
  /TABLES=Rating_d BY Screens
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT
  /COUNT ROUND CELL.


SUMMARIZE
  /TABLES=Rating BY Screens
  /FORMAT=NOLIST TOTAL
  /TITLE='Case Summaries'
  /MISSING=VARIABLE
  /CELLS=MEAN SEMEAN COUNT.



SUMMARIZE
  /TABLES=Rating_d BY Screens
  /FORMAT=NOLIST TOTAL
  /TITLE='Case Summaries'
  /MISSING=VARIABLE
  /CELLS=MEAN SEMEAN COUNT.


*Generalized Linear Mixed Models. ss.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=ss COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=6 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.



*Generalized Linear Mixed Models. itm.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=itm COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=6 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.


*Generalized Linear Mixed Models. cr.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=cr COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=6 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.


*Generalized Linear Mixed Models. Combined random intercepts. x6.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=ss COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=cr COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=6 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.




*Generalized Linear Mixed Models. Combined random intercepts. x100.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=ss COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=cr COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=100 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.



*Generalized Linear Mixed Models. + Random slopes.  x6.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM EFFECTS=Screens USE_INTERCEPT=TRUE SUBJECTS=ss COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /RANDOM EFFECTS=Screens USE_INTERCEPT=FALSE SUBJECTS=itm COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /RANDOM EFFECTS=Screens USE_INTERCEPT=TRUE SUBJECTS=cr COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=6 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.



*Generalized Linear Mixed Models. Combined random effects II x6.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM EFFECTS=Screens USE_INTERCEPT=TRUE SUBJECTS=ss COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /RANDOM EFFECTS=Screens USE_INTERCEPT=FALSE SUBJECTS=itm COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=6 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.


*Generalized Linear Mixed Models. Combined random effects. Simplified random effects. x100.
GENLINMIXED
  /DATA_STRUCTURE SUBJECTS=ss*itm*cr
  /FIELDS TARGET=Rating_d TRIALS=NONE OFFSET=NONE
  /TARGET_OPTIONS DISTRIBUTION=MULTINOMIAL LINK=LOGIT
  /FIXED EFFECTS=Screens USE_INTERCEPT=TRUE
  /RANDOM EFFECTS=Screens USE_INTERCEPT=TRUE SUBJECTS=ss COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /RANDOM EFFECTS=Screens USE_INTERCEPT=FALSE SUBJECTS=itm COVARIANCE_TYPE=VARIANCE_COMPONENTS SOLUTION=FALSE 
  /BUILD_OPTIONS TARGET_CATEGORY_ORDER=DESCENDING INPUTS_CATEGORY_ORDER=ASCENDING 
    HCONVERGE=0.00000001(RELATIVE) MAX_ITERATIONS=100 CONFIDENCE_LEVEL=95 DF_METHOD=RESIDUAL COVB=MODEL 
    SCORING=0 SINGULAR=0.000000000001
  /EMMEANS_OPTIONS SCALE=ORIGINAL PADJUST=LSD.





